/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.function;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.LuaInterpretedFunction;
import org.squiddev.cobalt.function.LuaInterpreter;

public final class Dispatch {
    private Dispatch() {
    }

    public static LuaValue call(LuaState state, LuaValue function) throws LuaError, UnwindThrowable {
        return Dispatch.call(state, function, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, int stack) throws LuaError, UnwindThrowable {
        LuaValue luaValue;
        if (function instanceof LuaFunction) {
            LuaFunction func = (LuaFunction)function;
            luaValue = Dispatch.callImpl(state, func);
        } else {
            luaValue = Dispatch.callImpl(state, Dispatch.getCallMetamethod(state, function, stack), function);
        }
        return luaValue;
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg) throws LuaError, UnwindThrowable {
        return Dispatch.call(state, function, arg, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg, int stack) throws LuaError, UnwindThrowable {
        LuaValue luaValue;
        if (function instanceof LuaFunction) {
            LuaFunction func = (LuaFunction)function;
            luaValue = Dispatch.callImpl(state, func, arg);
        } else {
            luaValue = Dispatch.callImpl(state, Dispatch.getCallMetamethod(state, function, stack), function, arg);
        }
        return luaValue;
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2) throws LuaError, UnwindThrowable {
        return Dispatch.call(state, function, arg1, arg2, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2, int stack) throws LuaError, UnwindThrowable {
        LuaValue luaValue;
        if (function instanceof LuaFunction) {
            LuaFunction func = (LuaFunction)function;
            luaValue = Dispatch.callImpl(state, func, arg1, arg2);
        } else {
            luaValue = Dispatch.callImpl(state, Dispatch.getCallMetamethod(state, function, stack), function, arg1, arg2);
        }
        return luaValue;
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2, LuaValue arg3) throws LuaError, UnwindThrowable {
        return Dispatch.call(state, function, arg1, arg2, arg3, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2, LuaValue arg3, int stack) throws LuaError, UnwindThrowable {
        LuaValue luaValue;
        if (function instanceof LuaFunction) {
            LuaFunction func = (LuaFunction)function;
            luaValue = Dispatch.callImpl(state, func, arg1, arg2, arg3);
        } else {
            luaValue = Dispatch.invokeImpl(state, Dispatch.getCallMetamethod(state, function, stack), ValueFactory.varargsOf(function, arg1, arg2, arg3)).first();
        }
        return luaValue;
    }

    public static Varargs invoke(LuaState state, LuaValue function, Varargs args) throws LuaError, UnwindThrowable {
        return Dispatch.invoke(state, function, args, -1);
    }

    public static Varargs invoke(LuaState state, LuaValue function, Varargs args, int stack) throws LuaError, UnwindThrowable {
        Varargs varargs;
        if (function instanceof LuaFunction) {
            LuaFunction func = (LuaFunction)function;
            varargs = Dispatch.invokeImpl(state, func, args);
        } else {
            varargs = Dispatch.invokeImpl(state, Dispatch.getCallMetamethod(state, function, stack), ValueFactory.varargsOf(function, args));
        }
        return varargs;
    }

    private static LuaValue callImpl(LuaState state, LuaFunction function) throws UnwindThrowable, LuaError {
        LuaValue result;
        DebugState ds = DebugState.get(state);
        DebugFrame di = ds.pushJavaInfo();
        if (function instanceof LuaInterpretedFunction) {
            LuaInterpretedFunction closure = (LuaInterpretedFunction)function;
            LuaInterpreter.setupCall(ds, di, closure, 2);
            result = LuaInterpreter.execute(state, di, closure).first();
        } else {
            di.func = function;
            try {
                ds.onCall(di);
            }
            catch (UnwindThrowable e) {
                di.extras = Constants.NONE;
                throw e;
            }
            result = ((LibFunction)function).call(state);
        }
        ds.onReturn(di, result);
        return result;
    }

    private static LuaValue callImpl(LuaState state, LuaFunction function, LuaValue arg1) throws UnwindThrowable, LuaError {
        LuaValue result;
        DebugState ds = DebugState.get(state);
        DebugFrame di = ds.pushJavaInfo();
        if (function instanceof LuaInterpretedFunction) {
            LuaInterpretedFunction closure = (LuaInterpretedFunction)function;
            LuaInterpreter.setupCall(ds, di, closure, arg1, 2);
            result = LuaInterpreter.execute(state, di, closure).first();
        } else {
            di.func = function;
            try {
                ds.onCall(di);
            }
            catch (UnwindThrowable e) {
                di.extras = arg1;
                throw e;
            }
            result = ((LibFunction)function).call(state, arg1);
        }
        ds.onReturn(di, result);
        return result;
    }

    private static LuaValue callImpl(LuaState state, LuaFunction function, LuaValue arg1, LuaValue arg2) throws UnwindThrowable, LuaError {
        LuaValue result;
        DebugState ds = DebugState.get(state);
        DebugFrame di = ds.pushJavaInfo();
        if (function instanceof LuaInterpretedFunction) {
            LuaInterpretedFunction closure = (LuaInterpretedFunction)function;
            LuaInterpreter.setupCall(ds, di, closure, arg1, arg2, 2);
            result = LuaInterpreter.execute(state, di, closure).first();
        } else {
            di.func = function;
            try {
                ds.onCall(di);
            }
            catch (UnwindThrowable e) {
                di.extras = ValueFactory.varargsOf(arg1, (Varargs)arg2);
                throw e;
            }
            result = ((LibFunction)function).call(state, arg1, arg2);
        }
        ds.onReturn(di, result);
        return result;
    }

    private static LuaValue callImpl(LuaState state, LuaFunction function, LuaValue arg1, LuaValue arg2, LuaValue arg3) throws UnwindThrowable, LuaError {
        LuaValue result;
        DebugState ds = DebugState.get(state);
        DebugFrame di = ds.pushJavaInfo();
        if (function instanceof LuaInterpretedFunction) {
            LuaInterpretedFunction closure = (LuaInterpretedFunction)function;
            LuaInterpreter.setupCall(ds, di, closure, arg1, arg2, arg3, 2);
            result = LuaInterpreter.execute(state, di, closure).first();
        } else {
            di.func = function;
            try {
                ds.onCall(di);
            }
            catch (UnwindThrowable e) {
                di.extras = ValueFactory.varargsOf(arg1, arg2, (Varargs)arg3);
                throw e;
            }
            result = ((LibFunction)function).call(state, arg1, arg2, arg3);
        }
        ds.onReturn(di, result);
        return result;
    }

    private static Varargs invokeImpl(LuaState state, LuaFunction function, Varargs args) throws UnwindThrowable, LuaError {
        Varargs result;
        DebugState ds = DebugState.get(state);
        DebugFrame di = ds.pushJavaInfo();
        if (function instanceof LuaInterpretedFunction) {
            LuaInterpretedFunction closure = (LuaInterpretedFunction)function;
            LuaInterpreter.setupCall(ds, di, closure, args, 2);
            result = LuaInterpreter.execute(state, di, closure);
        } else {
            di.func = function;
            try {
                ds.onCall(di);
            }
            catch (UnwindThrowable e) {
                di.extras = args;
                throw e;
            }
            result = ((LibFunction)function).invoke(state, args);
        }
        ds.onReturn(di, result);
        return result;
    }

    public static Varargs invokeFrame(LuaState state, DebugFrame frame) throws UnwindThrowable, LuaError {
        Varargs varargs;
        LuaFunction function = frame.func;
        if (function instanceof LuaInterpretedFunction) {
            LuaInterpretedFunction c = (LuaInterpretedFunction)function;
            varargs = LuaInterpreter.execute(state, frame, c);
        } else {
            varargs = ((LibFunction)function).invoke(state, frame.extras);
        }
        return varargs;
    }

    public static LuaFunction getCallMetamethod(LuaState state, LuaValue value, int stack) throws LuaError {
        assert (!(value instanceof LuaFunction));
        LuaValue func = value.metatag(state, Constants.CALL);
        if (!(func instanceof LuaFunction)) {
            throw ErrorFactory.operandError(state, value, "call", stack);
        }
        LuaFunction metaFunc = (LuaFunction)func;
        return metaFunc;
    }
}

